#!/bin/sh 
# uninstall.sh
# Created by Tresa on 08/03/11.# Copyright 2011 __MyCompanyName__. All rights reserved.

BASEDIR=$(dirname "$0")
cd "$BASEDIR"
#cd ../
cd "./UninstallFiles/"
cp -f -R "Printer Driver.zip" "/tmp/"

ditto -xk "/tmp/Printer Driver.zip" "/tmp/"

cd "/tmp/Printer Driver"

Common/PerformOperations.app/Contents/MacOS/PerformOperations -mode "root" -InstallerPath "$0"
sleep 5

while true;
do
if ps ax | grep -v grep | grep PerformOperations > /dev/null
then
	sleep 1
else
	break
fi
done
Common/PerformOperations.app/Contents/MacOS/PerformOperations -mode "user"
cd ../

rm -f -R "/tmp/Printer Driver"
rm -f -R "/tmp/Printer Driver.zip"

LOWER_VENDOR=`echo "$1" | tr "[:upper:]" "[:lower:]"`
RECEIPTS_REMOVE_COMMAND="ReceiptsRemove com.$LOWER_VENDOR.PrinterDriverInstaller.pkg*"


# $1 - full path to source directory (directory itself not copied)
# $2 - wildcard or file/dir name
function DirectoryRemoveSubset()
{
	if [ "1" = "$DETAIL_LEVEL" ] ; then
		echo "DirectoryRemoveSubset [$2] from [$1]"
	fi
	
	if [ "1" = "$DETAIL_LEVEL" ] ; then
		find "$1" -name "$2" -execdir rm -rfv {} \;	# debug ( verbose output )
	else
		find "$1" -name "$2" -execdir rm -rf {} \;	
	fi
}


# $1 - package name; wildcards allowed
function ReceiptsRemove()
{
	local oldFoldePath="/Library/Receipts"
	DirectoryRemoveSubset "$oldFoldePath" "$1"
	if [ $? -ne 0 ] ; then
			printf "warning:  !!!  cannot remove $oldFoldePath/$1 !!!\n"
	#		exit 1
	fi

	local newFoldePath="/var/db/receipts"
	DirectoryRemoveSubset "$newFoldePath" "$1"
	if [ $? -ne 0 ] ; then
			printf "warning:  !!!  cannot remove $newFoldePath/$1 (OK on Mac OS 10.5)   !!!\n"
	#		exit 1
	fi
}

###### remove PackageMaker stuff files
$RECEIPTS_REMOVE_COMMAND
